/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.LoginResponse;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.minecraft.MCInstaller;
import net.ftb.util.SwingUtils;

public class PlayOfflineDialog
extends JDialog {
    private JTextArea text;
    private JButton play;
    private JButton abort;

    public PlayOfflineDialog(String cause, final String username, final String uuid, final LoginResponse resp) {
        super((Frame)LaunchFrame.getInstance(), true);
        this.setupGui();
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModPack pack = ModPack.getSelectedPack();
                boolean legacy = false;
                if (!pack.getMcVersion().startsWith("14w") && Integer.parseInt(pack.getMcVersion().replaceAll("[^\\d]", "")) < 162) {
                    legacy = true;
                }
                if (pack.getDir().equalsIgnoreCase("mojang_vanilla")) {
                    legacy = false;
                }
                PlayOfflineDialog.this.setVisible(false);
                String unique = uuid == null || uuid.isEmpty() ? "1234567890" : uuid;
                MCInstaller.launchMinecraft(Settings.getSettings().getInstallPath(), ModPack.getSelectedPack(), new LoginResponse("1", "token", username, "offlinemods", unique, resp.getAuth()), legacy);
            }
        });
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayOfflineDialog.this.setVisible(false);
            }
        });
    }

    public void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle("Could not log in");
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.text = new JTextArea(I18N.getLocaleString("PLAYOFFLINE_WANNA"));
        this.text.setEditable(false);
        this.text.setHighlighter(null);
        this.text.setBorder(BorderFactory.createEmptyBorder());
        this.play = new JButton(I18N.getLocaleString("MAIN_YES"));
        this.abort = new JButton(I18N.getLocaleString("MAIN_NO"));
        panel.add(this.text);
        panel.add(this.abort);
        panel.add(this.play);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.text, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springSum(Spring.width(this.play), Spring.constant(10), Spring.width(this.abort), Spring.width(this.text));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.play, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.abort, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.text, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.text), Spring.constant(10));
        layout.putConstraint("North", (Component)this.play, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.abort, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.play), Spring.height(this.abort));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

